/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.extension;

import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.ExtensionWithContext;
import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solution.SolutionListener;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public class SearchIntensification<V extends Variable<V, T>, T extends Value<V, T>>
extends ExtensionWithContext<V, T, Context>
implements SolutionListener<V, T> {
    private static Logger sLogger = Logger.getLogger(SearchIntensification.class);
    private long iInitialIterationLimit = 100L;
    private ConflictStatistics<V, T> iCBS = null;
    private int iResetInterval = 5;
    private int iMux = 2;
    private int iMuxInterval = 2;

    public SearchIntensification(Solver<V, T> solver, DataProperties properties) {
        super(solver, properties);
        this.iInitialIterationLimit = properties.getPropertyLong("SearchIntensification.IterationLimit", this.iInitialIterationLimit);
        this.iResetInterval = properties.getPropertyInt("SearchIntensification.ResetInterval", this.iResetInterval);
        this.iMuxInterval = properties.getPropertyInt("SearchIntensification.MultiplyInterval", this.iMuxInterval);
        this.iMux = properties.getPropertyInt("SearchIntensification.Multiply", this.iMux);
    }

    @Override
    public boolean init(Solver<V, T> solver) {
        if (this.iResetInterval > 0) {
            for (Extension<V, T> ex : solver.getExtensions()) {
                if (!ConflictStatistics.class.isInstance(ex)) continue;
                this.iCBS = (ConflictStatistics)ex;
                break;
            }
        }
        return super.init(solver);
    }

    @Override
    public void register(Model<V, T> model) {
        super.register(model);
        this.getSolver().currentSolution().addSolutionListener(this);
    }

    @Override
    public void unregister(Model<V, T> model) {
        super.unregister(model);
        this.getSolver().currentSolution().removeSolutionListener(this);
    }

    @Override
    public void afterAssigned(Assignment<V, T> assignment, long iteration, T value) {
        ((Context)this.getContext(assignment)).afterAssigned(assignment, iteration, value);
    }

    @Override
    public void bestSaved(Solution<V, T> solution) {
        Context context = (Context)this.getContext(solution.getAssignment());
        context.bestSaved(solution);
    }

    @Override
    public void solutionUpdated(Solution<V, T> solution) {
    }

    @Override
    public void bestCleared(Solution<V, T> solution) {
    }

    @Override
    public void bestRestored(Solution<V, T> solution) {
    }

    @Override
    public void getInfo(Solution<V, T> solution, Map<String, String> info) {
    }

    @Override
    public void getInfo(Solution<V, T> solution, Map<String, String> info, Collection<V> variables) {
    }

    @Override
    public Context createAssignmentContext(Assignment<V, T> assignment) {
        return new Context(assignment);
    }

    public class Context
    implements AssignmentContext {
        private int iResetCounter = 0;
        private int iMuxCounter = 0;
        private long iLastReturn = 0L;
        private long iIterationLimit = 100L;

        public Context(Assignment<V, T> assignment) {
            this.iIterationLimit = SearchIntensification.this.iInitialIterationLimit;
        }

        public void afterAssigned(Assignment<V, T> assignment, long iteration, T value) {
            if (this.iIterationLimit > 0L && iteration > 0L) {
                Solution solution = SearchIntensification.this.getSolver().currentSolution();
                if (solution.getBestIteration() < 0L || !solution.isBestComplete()) {
                    return;
                }
                long bestIt = Math.max(solution.getBestIteration(), this.iLastReturn);
                long currIt = solution.getIteration();
                if (currIt - bestIt > this.iIterationLimit) {
                    this.iLastReturn = currIt;
                    ++this.iResetCounter;
                    ++this.iMuxCounter;
                    sLogger.debug((Object)"Going back to the best known solution...");
                    solution.restoreBest();
                    sLogger.debug((Object)("Reset counter set to " + this.iResetCounter));
                    if (SearchIntensification.this.iMuxInterval > 0 && this.iMuxCounter % SearchIntensification.this.iMuxInterval == 0) {
                        this.iIterationLimit *= (long)SearchIntensification.this.iMux;
                        sLogger.debug((Object)("Iteration limit increased to " + this.iIterationLimit));
                    }
                    if (SearchIntensification.this.iCBS != null && SearchIntensification.this.iResetInterval > 0 && this.iResetCounter % SearchIntensification.this.iResetInterval == 0) {
                        sLogger.debug((Object)"Reseting CBS...");
                        SearchIntensification.this.iCBS.reset();
                    }
                }
            }
        }

        public void bestSaved(Solution<V, T> solution) {
            if (this.iResetCounter > 0) {
                sLogger.debug((Object)"Reset counter set to zero.");
            }
            this.iResetCounter = 0;
            this.iMuxCounter = 0;
            this.iIterationLimit = SearchIntensification.this.iInitialIterationLimit;
        }
    }
}

